var apiHandle;//    = null;
var apiVersion;//   = undefined;
var noAPIFound   = "false";
var findAPITries = 0;
var terminated   = "false";
var _debug       = false;

/*******************************************************************************
**
** This function is used to communicate with the API, if it is found.
**
** Inputs:  String - Name of the api function to call
**
**			String - Name of the data model defined category or element value
**
**          String - The value that the named element or category will be
**                   assigned
**
** Return:  String - Value returned from the api call.
**
*******************************************************************************/
function apiCall( functionCall, dmeName, dmeValue )
{
	var api = getAPIHandle();
	var result;
		
	if( noAPIFound != "true" )
	{
		switch ( functionCall )
		{
			case "initialize":
				if ( apiVersion >=1 )
				{
					result = api.Initialize("");
				}
				else
				{
					result = api.LMSInitialize("");
				}
				break;
			
			case "terminate":
				if ( apiVersion >= 1 )
				{
					result = api.Terminate("");
				}
				else
				{
					result = api.LMSFinish("");
				}
				break;
			
			case "getValue":
				if ( apiVersion >=1 )
				{
					result = api.GetValue( dmeName );
				}
				else
				{
					result = api.LMSGetValue( dmeName );
				}
				break;
			
			case "setValue":
				if ( apiVersion >= 1 )
				{
					result = api.SetValue( dmeName, dmeValue );
				}
				else
				{
					result = api.LMSSetValue( dmeName, dmeValue );
				}
				break;
			
			case "commit":
				if ( apiVersion >= 1 )
				{
					result = api.Commit("");
				}
				else
				{
					result = api.LMSCommit("");
				}
				break;
			
			case "getLastError":
				if ( apiVersion >= 1 )
				{
					result = api.GetLastError();
				}
				else
				{
					result = api.LMSGetLastError();
				}
				break;
			
			case "getErrorString":
				if ( apiVersion >= 1 )
				{
					result = api.GetErrorString( errCode );
				}
				else
				{
					result = api.LMSGetErrorString( errCode );
				}
				break;
			
			case "getDiagnostic":
				if ( apiVersion >= 1 )
				{
					result = api.GetDiagnostic( error );
				}
				else
				{
					result = api.LMSGetDiagnostic( errorCode );
				}
				break;
		}
		return result;
	}
}

/*******************************************************************************
**
** This function looks for an object named API in parent and opener windows
**
** Inputs:  Object - The Window Object
**
** Return:  Object - If the API object is found, it's returned, otherwise null
**          is returned
**
*******************************************************************************/
function findAPI( win )
{
	var theAPI = null;
   while ( ( win.API_1484_11 == null ) && ( win.API == null ) && ( win.parent != null ) && ( win.parent != win ) )
   {
      findAPITries++;
      if ( findAPITries > 500 )
      {
         alert( "Error finding API -- too deeply nested." );
         return null;
      }
      win = win.parent;
   }
	if ( win.API_1484_11 != null )
	{
		apiVersion = 1;
		theAPI     = win.API_1484_11;
	}
	else if ( win.API != null )
	{
		apiVersion = 0;
		theAPI     = win.API;
	}
	return theAPI;
}

/*******************************************************************************
**
** This function looks for an object named API, first in the current window's
** frame hierarchy and then, if necessary, in the current window's opener window
** hierarchy (if there is an opener window).
**
** Inputs:  none
**
** Return:  Object - If the API object is found, it's returned, otherwise null
**                   is returned
**
*******************************************************************************/
function getAPI()
{
   var theAPI = findAPI( window );
		
   if ( ( theAPI == null ) && ( window.opener != null ) && ( typeof( window.opener ) != "undefined" ) )
   {
      theAPI = findAPI( window.opener );
   }

   if ( theAPI == null )
   {
      alert( "Unable to locate the LMS's API Implementation.\n" + "Communication with the LMS will not occur." );
      noAPIFound = "true";
   }
	/*
   else
   {
      //apiVersion = Number(theAPI.version);
		if ( theAPI.version )
		{
			apiVersion = Number( ( theAPI.version ).substr( 0, 3 ) );
			alert( apiVersion );
		}
		
   }
	*/	
   return theAPI;
}

/*******************************************************************************
**
** Returns the handle to API object if it was previously set, otherwise it
** returns null
**
** Inputs:  None
**
** Return:  Object - The value contained by the apiHandle variable.
**
*******************************************************************************/
function getAPIHandle()
{
   if ( apiHandle == null )
   {
      if ( noAPIFound == "false" )
      {
         apiHandle = getAPI();
      }
   }	
   return apiHandle;
}